 %{
--------------------------------------------------------------------------
Test Polynomial-Chaos-Expansion-Driven Partial Least Squares algorithm (PCE-PLS) on 1D bar example with KLE-discretized random field
--------------------------------------------------------------------------
Created by:
Fong-Lin Wu (fonglin.wu@tum.de)
Max Ehre (max.ehre@tum.de)
Technische Universitat Munchen
www.era.bgu.tum.de
---------------------------------------------------------------------------
Version: 
* 2019-10 Clean up and sync style with Python version
--------------------------------------------------------------------------
Input:
* V : Design input generated by Latin-Hypercube sampling for training
* Ve: Design input generated by Latin-Hypercube sampling for evaluation
--------------------------------------------------------------------------
Output:
* Y : Output from Finite-Element-Method
* Ye: Output from surrogate model (PCE-PLS)
--------------------------------------------------------------------------
Based on:

--------------------------------------------------------------------------
%}
close all; clear all; clc;
%rng(1,'twister');
fprintf('------------------Programm begins------------------\n\n')

%% parameters
p_pls = 5;    % maximum polynomial order of PLS-PCE
d_pls = 5;    % maximum number of components (directions)
d     = 100;  % original problem dimension 
ned   = 1000;  % number of training points to learn PLS-PCE model
nval  = 100;  % number of points to estimate generalization error

%% create training data
% generate inputs by Latin Hyper Cube sampling with minimized correlation
V = norminv(lhsdesign(ned,d,'criterion','correlation'));

fprintf('---------Generating training sets---------\n')
tic
% generate FE model output for training
for i = 1:ned
   Y(i,1) = bar_model(V(i,:)'); 
end
toc
fprintf('----------Taining sets generated----------\n\n')

%% training
fprintf('---------Training begins---------\n')
tic
% train PLS-PCE surrogate model by FE model output
[fpls, Ypls, R_err, d_red, pfinal] = pls_pce_R_combi(V,Y,d_pls,p_pls);
toc
fprintf('----------Training ends----------\n\n')

%% create evaluation data
% generate inputs by Latin Hyper Cube sampling with minimized correlation
Ve = norminv(lhsdesign(nval,d,'criterion','correlation'));

% generate FE model output for evaluation
fprintf('---------Generating evaluation sets---------\n')
tic
for i = 1:nval
   Ye(i,1) = bar_model(Ve(i,:)'); 
end
toc
fprintf('---------Evaluation sets generated----------\n\n')

%% prediction
% predict new data by PLS-PCE surrogate model 
fprintf('---------Surrogate model begins---------\n')
tic
Ye_pls = fpls(Ve);
toc
fprintf('----------Surrogate model ends----------\n')

% estimate generalisation error
err_pls = mean((Ye_pls - Ye).^2)/var(Ye)

fprintf('-------------------Programm ends-------------------\n\n')